local assets =
{
	Asset("ANIM", "anim/tsilk.zip"),
    Asset("ATLAS", "images/inventoryimages/tsilk.xml"),
}

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("tsilk")
    inst.AnimState:SetBuild("tsilk")
    inst.AnimState:PlayAnimation("BUILD")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	inst:AddComponent("stackable")
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
	inst:AddComponent("tradable")
    inst.components.inventoryitem.imagename = "tsilk"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/tsilk.xml"
    inst:AddComponent("selfstacker")

    MakeHauntableLaunchAndSmash(inst)

    return inst
end

return Prefab("tsilk", fn, assets)